% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/good3.R
\name{good3}
\alias{good3}
\title{Goodall 3 (G3) Measure}
\usage{
good3(data)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in colums.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the G3 similarity measure.
}
\details{
The Goodall 3 similarity measure was presented in (Boriah et al., 2008). It is a simple modification of the original Goodall measure (Goodall, 1966).           
The measure assigns higher weight if the infrequent categories match
regardless on frequencies of other categories.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.good3 <- good3(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
\cr
\cr
Goodall V.D. (1966). A new similarity index based on probability. Biometrics, 22(4), p. 882.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
