% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cardinal.R
\name{cardinal}
\alias{cardinal}
\alias{nom_card}
\alias{numerator}
\alias{nom_numer}
\title{Convert numbers to cardinal character vectors}
\usage{
cardinal(x, negative = getOption("nombre.negative", "negative"))

nom_card(x, negative = getOption("nombre.negative", "negative"))

numerator(x, negative = getOption("nombre.negative", "negative"))

nom_numer(x, negative = getOption("nombre.negative", "negative"))
}
\arguments{
\item{x}{A numeric vector}

\item{negative}{A character to append to negative numbers.
Defaults to \code{"negative"}.
Default can be changed by setting \code{options("nombre.negative")}.}
}
\value{
A character vector of the same length as \code{x}
}
\description{
\code{nom_card()} and \code{cardinal()} produce cardinal numbers.
\code{nom_numer()} and \code{numerator()} produce numerators.
The results are equivalent for integers, but \code{nom_card()} and \code{cardinal()}
support fractional components while \code{nom_numer()} and \code{numerator()} do not.
}
\examples{
nom_card(2)
nom_card(1:10)
nom_card(2 + 4/9)
nom_card(-2)
nom_card(-2, negative = "minus")

nom_card(525600)
paste("There are", nom_card(525600), "minutes in a year.")

nom_card(3.72e13)
paste("There are", nom_card(3.72e13), "cells in the human body.")
}
