% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZnnself}
\alias{funsZnnself}
\alias{Znnself.ct}
\alias{Znnself}
\title{Self-Reflexivity Tests with Normal Approximation}
\usage{
Znnself.ct(
  ct,
  VarNii,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Znnself(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{The NNCT or SCCT, used in \code{Znnself.ct} only}

\item{VarNii}{The variance vector of differences of self entries in the SCCT or diagonal entries in the NNCT,
used in \code{Znnself.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the self entries in the SCCT or diagonal entries in the NNCT}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Znnself} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Znnself} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Znnself} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{vector} (of length k) of \eqn{Z} test statistics for NN self reflexivity test}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{vector} of \eqn{p}-values for the hypothesis test for the corresponding alternative}
\item{LCL,UCL}{Lower and Upper Confidence Levels, it is \code{NULL} here since we provide confidence intervals
as a \eqn{k \times 2} matrix.} 
\item{conf.int}{The \eqn{k \times 2} matrix of confidence intervals for the estimates, (where each row is the
confidence interval for self entry \eqn{S_i} in the SCCT or diagonal entry \eqn{N_{ii}} in the NNCT).}
\item{cnf.lvl}{Level of the confidence intervals (i.e., conf.level) for the self entries in the SCCT or
diagonal entries in the NNCT.}
\item{estimate}{The \code{vector} of estimates of the parameters, i.e., observed values of self entries 
in the SCCT or diagonal entries in the NNCT.}
\item{est.name,est.name2}{Names of the estimates, both are same in this function.}
\item{null.value}{The \code{vector} of null values of the parameters, i.e., expected values of self entries 
in the SCCT or diagonal entries in the NNCT under RL or CSR.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Znnself.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Znnself} only}
}
\description{
Two functions: \code{Znnself.ct} and \code{Znnself}.

Both functions are objects of class \code{"cellhtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected values of the self entries (i.e. first column)
in a species correspondence contingency table (SCCT) or the expected values of the diagonal entries \eqn{N_{ii}} in
an NNCT to the ones under RL or CSR.
That is, each performs NN self reflexivity for each class test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
NN self reflexivity is for each class can be viewed as a decomposition of species correspondence for
each class.
(See \insertCite{ceyhan:NNCorrespond2018;textual}{nnspat} for more detail).

Each test is based on the normal approximation of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the diagonal entries \eqn{N_{ii}} in an NNCT and
are due to \insertCite{ceyhan:NNCorrespond2018}{nnspat}.

Each function yields a \code{vector} of length \eqn{k} of the test statistics, \eqn{p}-values for the corresponding 
alternative, null values (i.e. expected values), sample estimates (i.e. observed values) of self entries 
in the SCCT or diagonal entries in the NNCT, a \eqn{k \times 2} matrix of confidence intervals (where each row is the
confidence interval for self entry \eqn{S_i} in the SCCT or diagonal entry \eqn{N_{ii}} in the NNCT) and
also names of the test statistics, estimates, null values and the method and the data
set used.

The null hypothesis is that all \eqn{E[S_i] = E[N_{ii}] = n_i(n_i - 1)/(n - 1)} where \eqn{n_i} is the size of class \eqn{i} and
\eqn{n} is the data size.

The \code{Znnself} functions (i.e. \code{Znnself.ct} and \code{Znnself}) are different from the \code{Znnref} functions 
(i.e. \code{\link{Znnref.ct}} and \code{\link{Znnref}}) and from \code{Zself.ref} functions (i.e. \code{\link{Zself.ref.ct}} and \code{\link{Zself.ref}}) and also from
\code{Znnself.sum} functions (i.e. \code{Znnself.sum.ct} and \code{Znnself.sum}).
\code{Znnself} functions are testing the self reflexivity at a class-specific level (i.e. for each class) using the
first column in the SCCT, while \code{Zself.ref} functions are for testing the self reflexivity for the entire data set
using entry \eqn{(1,1)} in RCT, and \code{Znnref} functions are for testing the self reflexivity and mixed non-reflexivity
using the diagonal entries in the RCT, and
\code{Znnself.sum} functions are testing the cumulative species correspondence using the sum of the self column (i.e.,
the first column) in the SCCT.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
VarN.diag<-varNii.ct(ct,Qv,Rv)

Znnself(Y,cls)
Znnself(Y,cls,alt="g")

Znnself.ct(ct,VarN.diag)
Znnself.ct(ct,VarN.diag,alt="g")

Znnself(Y,cls,method="max")

ct<-scct(ipd,cls)
Znnself.ct(ct,VarN.diag)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Znnself(Y,fcls)
Znnself.ct(ct,VarN.diag)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
VarN.diag<-varNii.ct(ct,Qv,Rv)

Znnself(Y,cls,alt="l")
Znnself.ct(ct,VarN.diag)
Znnself.ct(ct,VarN.diag,alt="l")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zself.ref.ct}}, \code{\link{Zself.ref}}, \code{\link{Znnref.ct}},
\code{\link{Znnref}}, \code{\link{Xsq.spec.cor}} and \code{\link{Xsq.spec.cor.ct}}
}
\author{
Elvan Ceyhan
}
