% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsPseg.ss}
\alias{funsPseg.ss}
\alias{Pseg.ss.ct}
\alias{Pseg.ss}
\title{Pielou's Overall Test of Segregation for NNCT (for Sparse Sampling)}
\usage{
Pseg.ss.ct(ct, yates = TRUE, sim = FALSE, Nsim = 2000)

Pseg.ss(dat, lab, yates = TRUE, sim = FALSE, Nsim = 2000, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Pseg.ss.ct} only}

\item{yates}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, Yates continuity correction is applied,
and if \code{FALSE} the continuity correction is not applied. 
Equivalent to the \code{correct} argument in the base function \code{\link[stats]{chisq.test}}}

\item{sim}{A logical parameter (default=\code{FALSE}). If \code{TRUE}, \eqn{p}-values are computed by Monte Carlo simulation
and if \code{FALSE} the \eqn{p}-value is based on the chi-squared approximation.
Equivalent to the \code{simulate.p.value} argument in the base function \code{\link[stats]{chisq.test}}}

\item{Nsim}{A positive integer specifying the number of replicates used in the Monte Carlo test.
Equivalent to the \code{B} argument in the base function \code{\link[stats]{chisq.test}}}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Pseg.ss} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Pseg.ss} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. 
used in \code{Pseg.ss} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The overall chi-squared statistic}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is (k-1)^2 for this function. 
Yields \code{NA} if \code{sim=TRUE} and \code{NSim} is provided.}
\item{estimate}{Estimates of the parameters, NNCT, i.e., matrix of the observed \eqn{N_{ij}} values
which is the NNCT.}
\item{est.name,est.name2}{Names of the estimates, they are identical for this function.}
\item{null.value}{Matrix of hypothesized null values for the parameters which are expected values of the
the \eqn{N_{ij}} values in the NNCT.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Pseg.ss.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Pseg.ss} only}
}
\description{
Two functions: \code{Pseg.ss.ct} and \code{Pseg.ss}.

Both functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
cell counts from the expected values under independence for all cells (i.e., entries) combined in the NNCT.
That is, each test is Pielou's overall test of segregation based on NNCTs for \eqn{k \ge 2} classes.
This overall test is based on the chi-squared approximation,
is equivalent to Pearson's chi-squared test on NNCT and
is due to \insertCite{pielou:1961;textual}{nnspat}.
Each test is appropriate (i.e. have the appropriate asymptotic sampling distribution)
when that data is obtained by sparse sampling.

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{(k-1)^2}, description of the 
alternative with the corresponding null values (i.e. expected values) of NNCT entries,
sample estimates (i.e. observed values) of the entries in NNCT.
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis is that \eqn{E(N_{ij})=n_i c_j /n} for all entries in the NNCT
where \eqn{n_i} is the sum of row \eqn{i} (i.e. size of class \eqn{i}), \eqn{c_j} is the sum of column \eqn{j} in the \eqn{k \times k} NNCT for \eqn{k \ge 2}.
In the output, the test statistic and the \eqn{p}-value are valid only 
for (properly) sparsely sampled data.

See also (\insertCite{pielou:1961,ceyhan:eest-2010;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

Pseg.ss(Y,cls)

Pseg.ss.ct(ct)
Pseg.ss.ct(ct,yates=FALSE)

Pseg.ss.ct(ct,yates=FALSE,sim=TRUE)
Pseg.ss.ct(ct,yates=FALSE,sim=TRUE,Nsim=10000)

Pseg.ss(Y,cls,method="max")
Pseg.ss(Y,cls,yates=FALSE,sim=TRUE,Nsim=10000,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Pseg.ss(Y,fcls)
Pseg.ss.ct(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

Pseg.ss(Y,cls)
Pseg.ss.ct(ct,yates=FALSE)

Pseg.ss(Y,cls, sim = TRUE, Nsim = 2000)
Pseg.ss.ct(ct,yates=FALSE) 

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{overall.nnct.ct}}, \code{\link{overall.nnct}}, \code{\link{overall.seg.ct}},
\code{\link{overall.seg}} and \code{\link[stats]{chisq.test}}
}
\author{
Elvan Ceyhan
}
