% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_extract.R
\name{raster_extract}
\alias{raster_extract}
\title{Wrapper for \code{raster::extract} on \code{stars} objects}
\usage{
raster_extract(x, y, fun = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{A \code{stars} object}

\item{y}{An \code{sf} object}

\item{fun}{A function to summarize raster values, default is \code{NULL}}

\item{na.rm}{If \code{TRUE}, \code{NA} will be removed before passing raster cells to function. Default is \code{FALSE}}
}
\value{
A vector, \code{matrix}, or \code{list}
}
\description{
This is a wrapper around \code{raster::extract}, to apply the function on \code{stars} objects without needing to convert to and from a \code{Raster*} object.
}
\examples{
library(stars)
tif = system.file("tif/L7_ETMs.tif", package = "stars")
r = read_stars(tif)
pol = st_sfc(st_buffer(st_point(c(293749.5, 9115745)), 400), crs = st_crs(r))
plot(r[,,,1], reset = FALSE)
plot(pol, add = TRUE, border = "red")
raster_extract(r, pol)
raster_extract(r, pol, fun = mean)

}
