% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nneo_wrangle.R
\name{nneo_wrangle}
\alias{nneo_wrangle}
\title{Download and wrangle NEON's sensor-based data products}
\usage{
nneo_wrangle(site_code = "BART", time_start = "2016-06-20",
  time_end = NULL, data_var = "active radiation", time_agr = 30,
  package = "basic")
}
\arguments{
\item{site_code}{(character) a site code. Required.}

\item{time_start}{(character) YYYY-MM-DD start day to check for files.
Required if time_end=NULL}

\item{time_end}{(character) YYYY-MM-DD end day to check for files.
Required if time_start=NULL}

\item{data_var}{(character) NEON data product(s) to be downloaded. The user
may enter a specific, controlled, NEON data product or they may enter a
generic term if wanting multiple, similar, NEON data products. For instance,
defining data_var as "Photosythetically Active Radiation (Quantum Line)"
would satisfy the former, and defining data_var as "Active Radiation" or
just "Radiation" would satisfy the latter. Required}

\item{time_agr}{(numeric) Aggregation period, given in minutes, of NEON data
product(s) to be downloaded
(e.g. \code{1} corresponds to a 1-minute data product). Required.}

\item{package}{(character) Package type to return, basic or expanded.
'Expanded' datasets are only available for the smallest time_agr of each
NEON data product. NOTE: 'expanded' datasets are much larger than 'basic'
and will take considerably more time to download. Required}
}
\value{
Returns a tibble of relevant data products from all spatial
locations at a NEON site for the custom time period.  Data products are
displayed via 'productName.spatialLocation', e.g., 'difRadMean.000.060' is
mean, diffuse, shortwave radiation as measured on the 6th measurement level
of a NEON tower (000.060), while 'linePARMean.005.000' is mean,
photosynthetically Active Radiation (PAR) as measured at the 5th soil plot
(005.000) of a NEON site.  More information regarding spatial location and
identifiers can be found at the references below.
}
\description{
Retrieve related, sensor-based datasets at a given NEON site for
a custom time period, merged per measurement level and/or variable
}
\examples{
\dontrun{
#download 30-minute, radiation data from NEON's Bartlett site for Summer 2016
nneo_wrangle(site_code="BART", time_start="2016-06-20",
time_end="2016-09-21", data_var="radiation")
#download 1-minute, dust data from NEON's Sterling (STER) site for 2017-03-04
nneo_wrangle(site_code="STER",time_start="2017-03-04",data_var="dust",
time_agr=60)
}
}
\references{
\href{http://data.neonscience.org/home}{NEON Data Portal}\cr
\href{http://data.neonscience.org/view-data-availability}{NEON Data Availability}
}
\seealso{
Currently none
}
\author{
Josh Roberti \email{jaroberti87@gmail.com}\cr
Dave Durden\cr
Robert Lee
}
\keyword{(NEON),}
\keyword{Ecological}
\keyword{Ecology,}
\keyword{NEON,}
\keyword{National}
\keyword{Network}
\keyword{Observatory}
\keyword{atmosphere}
\keyword{climate,}
\keyword{data}
\keyword{data,}
\keyword{environmental}
\keyword{products,}
