\name{ll.edm}
\alias{ll.edm}
\title{Nonlinear forecasting of local polynomial `empirical dynamic model'.}
\description{
  A function to forcast a local polynomial `empirical dynamic model'.
}

\usage{
    ll.edm(x, order, bandwidth, len=NA, deg = 2)
    }

\arguments{
  \item{x}{A time series without missing values.}
  \item{order}{The order for the nonparametric (local polynomial) autoregression.}
  \item{bandwidth}{The bandwidth for the nonparametric (local polynomial) autoregression.}
  \item{len}{The length of the predicted time-series. If NA the length of the training time series will be used.}  
  \item{deg}{The degree of the local polynomial.}
}

\details{
The function produces a nonlinear (nonparametric) forecast using the conditional mean method of Fan et al (1996). A Gaussian kernel is used for the local polynomial autoregression. 

The bandwidth and order is best estimated with the \code{\link{ll.order}}-function. 

Missing values are NOT permitted.

If \code{deg} is set to 0, the forecast uses the Nadaraya-Watson (locally constant) estimator of 
the conditional expecation against lagged-abundances.

The function requires Loader's \code{locfit}-library.
}

\value{
  A time series with the nonlinear (nonparametric) forecast is returned 
} 

\references{
Fan, J., Yao, Q., & Tong, H. (1996) Estimation of 
conditional densities and sensitivity measures 
in nonlinear dynamical systems. Biometrika, 83, 189-206.

Loader, C. (1999) Local Regression and Likelihood. 
Springer, New York.
}

\author{Ottar N. Bjornstad \email{onb1@psu.edu}}

\seealso{
\code{\link{ll.order}}
}

\examples{
   data(plodia)

   sim1 <- ll.edm(sqrt(plodia), order=2, bandwidth = 1.5) 

  \dontrun{plot(sim1, type='b'))}
}

\keyword{ts}
