% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{lsi_reg}
\alias{lsi_reg}
\title{Regularized Linear Least Squares}
\usage{
lsi_reg(a, b, u = NULL, co = NULL, rcond = 1e+10, mnorm = NULL, x0 = NULL)
}
\arguments{
\item{a}{dense matrix A or its QR decomposition}

\item{b}{right hand side vector}

\item{u}{dense matrix of inequality constraints}

\item{co}{right hand side vector of inequality constraints}

\item{rcond}{used for calculating \code{lambda=d[1]/sqrt(rcond)} where \code{d[1]} is maximal singular value of a}

\item{mnorm}{norm matrix (can be dense or sparse) for which \%*\% operation with a dense vector is defined}

\item{x0}{optional vector from which a least norm distance is searched for}
}
\value{
solution vector whose attribute 'mes' may contain a message about possible
numerical problems and 'lambda' is regularization parameter used in solution.
}
\description{
solve linear least square problem \code{(min_x ||a*x-b||)}
with inequality constraints ux>=co
If a is rank deficient, regularization term \code{lambda^2*||mnorm*(x-x0)||^2}
is added to \code{||a*x-b||^2}.
}
\details{
The rank of a is estimated as number of singular values
above \code{d[1]*1.e-10} where \code{d[1]} is the highest singular value.
The scalar lambda is an positive number
and is calculated as \code{d[1]/sqrt(rcond)} ('rcond' parameter is preserved
for compatibility with others lsi_...() functions).
At return, lambda can be found in attributes of the returned vector x.
NB. lambda is set to NA
\itemize{
\item if rank(a)==0 or a is of full rank
\item or if there is no inequality.
If the matrix mnorm is NULL, it is supposed to be an identity matrix.
If the vector x0 is NULL, it is treated as 0 vector.
}
}
\seealso{
\link{lsi_ln}
}
