% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX_UNI.loading_helper.R
\name{getMIX_UNI.loadings}
\alias{getMIX_UNI.loadings}
\title{Get Factor Loadings for a Mixture Model or Multiple Group Model with Univariate Longitudinal Outcome}
\usage{
getMIX_UNI.loadings(
  nClass,
  y_model,
  t_var,
  records,
  y_var,
  curveFun,
  intrinsic
)
}
\arguments{
\item{nClass}{An integer specifying the number of classes for the mixture model or multiple group model. It takes the value
passed from \code{getMIX()} or \code{getMGroup()}.}

\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and
\code{"LCSM"}. It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getMIX()} or
\code{getMGroup()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getMIX()} or \code{getMGroup()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getMIX()} or \code{getMGroup()}.}
}
\value{
A list containing the specification of definition variables (i.e., individual time points for the latent
growth curve models, and individual time points and individual time lags (intervals) between adjacent time points
for latent change score models) and factor loadings of a univariate longitudinal outcome.
}
\description{
This function specifies the factor loadings for a mixture model with a univariate longitudinal outcome. The longitudinal
outcome is fit by a Latent Growth Curve Model or a Latent Change Score Model.
}
\keyword{internal}
