% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX.SUBMODEL.MGM_helper.R
\name{getsub.MGM_l}
\alias{getsub.MGM_l}
\title{Define Multivariate Latent Growth Curve Models or Multivariate Latent Change Score Models as Class-specific Models
(Submodels) for a Longitudinal Mixture Model}
\usage{
getsub.MGM_l(
  dat,
  nClass,
  t_var,
  y_var,
  curveFun,
  intrinsic,
  records,
  y_model,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions for each longitudinal process, and time-invariant covariates (TICs) if any.
It takes the value passed from \code{getMIX()}.}

\item{nClass}{An integer specifying the number of latent classes for the mixture model. It takes the value passed from \code{getMIX()}.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding outcome variable at each study wave. It takes the value passed from \code{getMIX()}.}

\item{y_var}{A vector of strings, with each element representing the prefix for column names corresponding to a
particular outcome variable at each study wave. It takes the value passed from \code{getMIX()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getMIX()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getMIX()}.}

\item{records}{A list of numeric vectors, with each vector specifying the indices of the observed study waves for
the corresponding outcome variable. It takes the value passed from \code{getMIX()}.}

\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getMIX()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMIX()} or derived
by the helper function \code{getMIX.initial()}.}
}
\value{
A list of manifest and latent variables and paths for an mxModel object.
}
\description{
This function defines multivariate latent growth curve models or multivariate latent change score models as class-
specific models (submodels) for a longitudinal mixture model.
}
