% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCM.R
\name{backwardSearch}
\alias{backwardSearch}
\title{Backward covariate search}
\usage{
backwardSearch(
  varsVec,
  covarsVec,
  catvarsVec = NULL,
  fitorig,
  fitupdated,
  pVal = 0.01,
  reFitCovars = FALSE,
  outputDir,
  restart = FALSE
)
}
\arguments{
\item{varsVec}{character vector of variables that need to be added}

\item{covarsVec}{character vector of covariates that need to be added}

\item{catvarsVec}{character vector of categorical covariates that need to be added}

\item{fitorig}{the original 'fit' object before forward search}

\item{fitupdated}{the updated 'fit' object, if any, after the forward search}

\item{pVal}{p-value that should be used for selecting covariates in the forward search}

\item{reFitCovars}{if the covariates should be added before performing backward search - useful for directly performing backward search without forward search; default is FALSE}

\item{outputDir}{the name of the output directory that stores the covariate search result}

\item{restart}{a boolean that controls if the search should be restarted; default is FALSE}
}
\value{
returns the updated 'fit' object at the end of the backward search and a table of information for all the covariates tested
}
\description{
Backward covariate search
}
\author{
Vipul Mann, Matthew Fidler, Vishal Sarsani
}
