% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp3xd4YE/filefb273b5b20d
\name{rankSample}
\alias{rankSample}
\title{Generates a weighted sample (with replacement) of ranks}
\usage{
rankSample(weights, size, output, silent = FALSE)
}
\arguments{
\item{weights}{A vector of numeric weights. Does not need to sum to 1, but must be non-negative}\item{size}{Size of sample}\item{output}{An R object into which the values will be placed. See example below for proper use}\item{silent}{Logical indicating whether to suppress logging information}}\description{
Takes a set of non-negative \code{weights} (do not need to sum to 1) and
returns a sample with \code{size} elements of the integers \code{1:length(weights)}, where the probability of being sampled is proportional
to the value of \code{weights}. An important note is that the output vector
will be sorted in ascending order. Also, right now it works slightly odd syntax (see example below). Later releases of NIMBLE will contain more natural syntax.
}
\details{
If invalid weights provided (i.e. negative weights or weights sum to 1), sets output = rep(1, size) and prints warning.
\code{rankSample} can be used inside nimble functions.

\code{rankSample} first samples from the joint distribution \code{size} uniform(0,1) distributions by conditionally sampling from the rank statistics. This leads to
a sorted sample of uniform(0,1)'s. Then, a cdf vector is constructed from weights. Because the sample of uniforms is sorted, \code{rankSample} walks
down the cdf in linear time and fills out the sample.
}
\examples{
set.seed(1)
sampInts = NA	#sampled integers will be placed in sampInts
rankSample(weights = c(1, 1, 2), size = 10, sampInts)
sampInts
# [1] 1 1 2 2 2 3 3 3 3 3
rankSample(weights = c(1, 1, 2), size = 10000, sampInts)
table(sampInts)
#sampInts
#   1    2    3
#2429 2498 5073

#Used in a nimbleFunction
sampGen <- nimbleFunction(setup = function(){
	x = 1:2
},
run = function(weights = double(1), k = integer() ){
	rankSample(weights, k, x)
	returnType(integer(1))
	return(x)
})
rSamp <- sampGen()
cSamp <- compileNimble(rSamp)
cSamp$run(1:4, 5)
#[1] 1 1 4 4 4
}
\author{
Clifford Anderson-Bergman
}

