% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_tools.R
\name{sim_plot}
\alias{sim_plot}
\title{Visualize Summaries of Simulation Results}
\usage{
sim_plot(x, ..., sample_sizes, stat = c("bias", "mc_var", "mse"))
}
\arguments{
\item{x}{A \code{list} of several simulation summary objects, of class
\code{simulation_stats}.}

\item{...}{Extra arguments currently ignored.}

\item{sample_sizes}{A \code{numeric} vector giving the sample sizes at which
each of the simulations in the input \code{x} was performed. There should be
one unique sample size corresponding to each element of \code{x}.}

\item{stat}{A \code{character} indicating which of three simulation summary
statistics for which to generate a plot. Options are currently limited to
bias (\code{"bias"}), variance (\code{"mc_var"}), and mean-squared error
(\code{"mse"}).}
}
\description{
Visualize Summaries of Simulation Results
}
\examples{
n_sim <- 100
n_obs <- c(100, 10000)
mu <- 2
sim_results <- lapply(n_obs, function(sample_size) {
  estimator_sim <- lapply(seq_len(n_sim), function(iter) {
    y_obs <- rnorm(sample_size, mu)
    est_param <- mean(y_obs)
    est_var <- var(y_obs)
    estimate <- tibble::as_tibble(list(
      param_est = est_param,
      param_var = est_var
    ))
    return(estimate)
  })
  estimates <- do.call(rbind, estimator_sim)
  return(estimates)
})
sim_summary <- lapply(sim_results, summarize_sim, truth = mu)
p_sim_summary <- sim_plot(sim_summary, sample_sizes = n_obs, stat = "mse")
p_sim_summary
}
