% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVI.R
\name{EVI}
\alias{EVI}
\title{EVI - Enhanced Vegetation Index}
\usage{
EVI(B, R, NIR)
}
\arguments{
\item{B}{A raster layer object with the reflectance values for the Blue band.}

\item{R}{A raster layer object with the reflectance values for the Red band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}
}
\value{
EVI - Enhanced Vegetation Index.
}
\description{
EVI is similar to the Normalized Difference Vegetation Index. However, EVI corrects for some atmospheric conditions and canopy background noise and is more sensitive in areas with dense vegetation.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
EVI(x[[2]], x[[4]], x[[5]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
