% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesSearch}
\alias{nhanesSearch}
\title{Perform a search over the comprehensive NHANES variable list.}
\usage{
nhanesSearch(search_terms = NULL, ignore.case = FALSE, ystart = NULL,
  ystop = NULL, includerdc = FALSE, nchar = 100, namesonly = FALSE)
}
\arguments{
\item{search_terms}{List of terms or keywords.}

\item{ignore.case}{Ignore case if TRUE. Default value is FALSE.}

\item{ystart}{Four digit year of first survey included in search, where ystart >= 1999.}

\item{ystop}{Four digit year of final survey included in search, where ystop >= ystart.}

\item{includerdc}{If TRUE then RDC only tables are included in list.}

\item{nchar}{Truncates the variable description to a max length of nchar.}

\item{namesonly}{If TRUE then only the table names are returned.}
}
\value{
A list of tables that match the search terms. 
If namesonly=TRUE, then only the table names are returned.
}
\description{
The descriptions in the master variable list will be filtered by the
provided search terms to retrieve a list of relevant variables. 
The search can be restricted to specific survey years by specifying ystart and/or ystop.
}
\details{
nhanesSearch is useful to obtain a comprehensive list of relevant tables.
}
\examples{
 \donttest{nhanesSearch("bladder", ystart=2001, ystop=2008, nchar=50)}
 \donttest{nhanesSearch("urin", ignore.case=TRUE, ystart=2009, namesonly=TRUE)}
 \donttest{nhanesSearch(c("urine", "urinary"), ignore.case=TRUE, ystop=2006, namesonly=TRUE)}
}

