\name{summary.autologistic}
\alias{summary.autologistic}
\title{Print a summary of a centered autologistic model fit.}
\usage{
  \method{summary}{autologistic} (object, alpha = 0.05,
    digits = 4, ...)
}
\arguments{
  \item{object}{an object of class \code{autologistic},
  typically the result of a call to
  \code{\link{autologistic}}.}

  \item{alpha}{the significance level for the quantile/HPD
  intervals. The default is 0.05.}

  \item{digits}{the number of significant digits to
  display. The default is 4.}

  \item{\dots}{additional arguments.}
}
\description{
  Print a summary of a centered autologistic model fit.
}
\details{
  This function displays (1) the call to
  \code{\link{autologistic}}, (2) the values of the control
  parameters, (3) a table of estimates, and (4) the size of
  the bootstrap/posterior sample. Each row of the table of
  estimates shows a parameter estimate, the confidence or
  HPD interval for the parameter, and, where applicable,
  the Monte Carlo standard error.
}
\seealso{
  \code{\link{autologistic}}
}

