% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{apply}
\alias{apply}
\title{Apply a loaded nfer specification to a dataframe of events.}
\usage{
apply(handle, events)
}
\arguments{
\item{handle}{The loaded nfer specification
(using \code{nfer::load}, or \code{nfer::learn})}

\item{events}{The dataframe of events to abstract using nfer.}
}
\value{
A dataframe containing intervals.
}
\description{
This function obtains the interval abstractions generated by applying the
nfer specification to the events.
}
\details{
Event traces are passed as dataframes with at least two columns.
The first two columns contain event names and timestamps, respectively.
Names should be strings.  Timestamps should be integers or strings, ideally, but may be numeric.
Subsequent columns contain data, where the column name is the data key.
The column value will be the data value for each event, where NA means no value is present.

Example dataframe events: \preformatted{
| name | timestamp | x |    y |
-------------------------------
| foo  | 123       | 2 | NA   |
| bar  | 987       | 3 | TRUE |
}

The result of the function is also a dataframe, but this contains intervals.
The difference is that it has an extra timestamp column.
Column two is now the start time of the interval, and column 3 is the end time.
Name is still column one and columns 4+ are still data.

Dataframe interval output: \preformatted{
| name | start | end | z  |
---------------------------
| far  | 123   | 987 | NA |
| baf  | 654   | 987 | 3  |
}
}
\examples{
ops <- nfer::load(system.file("extdata", "ops.nfer", package = "nfer"))
events <- nfer::read(system.file("extdata", "ops.events", package = "nfer"))
intervals <- nfer::apply(ops, events)
}
