% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/simplex.R
\docType{methods}
\name{closure}
\alias{closure}
\alias{closure-method}
\alias{closure,numeric-method}
\alias{closure,matrix-method}
\title{Closure Operation}
\usage{
closure(x, ...)

\S4method{closure}{numeric}(x, total = 1, na.rm = FALSE)

\S4method{closure}{matrix}(x, total = 1, na.rm = FALSE)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector or matrix.}

\item{...}{Currently not used.}

\item{total}{A \link{numeric} vector specifying the total amount to which the
compositions should be closed (defaults to 1).}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values be removed?}
}
\value{
A \code{\link{numeric}} vector or matrix (same as \code{x}).
}
\description{
Closes compositions to sum up to 1.
}
\examples{
x <- as_composition(c(1, 2, 3))
y <- as_composition(c(1, 2, 1))

## Perturbation
perturbation(x, y)
x + y

## Powering
powering(y, 2)
y * 2

## Scalar product
scalar(x, y)
}
\seealso{
Other operations in the simplex: 
\code{\link{arithmetic}},
\code{\link{perturbation}()},
\code{\link{powering}()},
\code{\link{scalar}()}
}
\author{
N. Frerebeau
}
\concept{operations in the simplex}
