% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocumentation.R
\docType{data}
\name{tipi}
\alias{tipi}
\title{Ten Item Personality Questionnaire}
\format{a dataframe. Columns represent questionnaire items and rows represent individuals}
\usage{
tipi
}
\description{
This dataset includes 1899 online participants who participated
in a questionnaire available through the Open Source Psychometrics
Project (https://openpsychometrics.org/), an organization that maintains an 
open website for the public to take psychometric tests for 
educational and entertainment purposes
}
\details{
The Ten Item Personality Questionnaire (TIPI) is a brief inventory of the Big 
Five personality domains. Each personality domain is assessed with two 
items. One item measures the domain normally and the other item measures 
the domain in reverse (e.g., "reserved, quiet" for reverse extraversion).

Labels for TIPI items in this dataset correspond to the first letter of 
each Big Five personality domain (Extraversion, Neuroticism, 
Conscientiousness, Agreeableness, and Openness to experience), 
with the character ``r'' indicating items that measure the domain 
in reverse.

Also includes demographics such as education level, 
rearing environment (urban/suburban/rural), gender, 
English as a native language, age, religion, sexual orientation, 
race, voting status, marriage status, and number of children 
in one's family during childhood.

The dataset is publicly available at http://openpsychometrics.org/_rawdata/GCBS.zip
and can be cited as:

OpenPsychometrics (2019). Generic Conspiracist Beliefs Scale Survey. Retrieved from http://openpsychometrics.org/_rawdata/GCBS.zip
}
\examples{
head(tipi)
\donttest{

## Example networktree with TIPI
data(tipi)
nodeVars <- c("E","A_r","C","N","O","E_r","A","C_r","N_r","O_r")
splitVars <- c("gender","education","engnat")
myTree<-networktree(tipi[,nodeVars], tipi[,splitVars])
myTree
plot(myTree)

}

}
\keyword{datasets}
