% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_impact.R
\name{structure.impact}
\alias{structure.impact}
\title{Network Structure Impact}
\usage{
structure.impact(input, gamma, nodes = c("all"), binary.data = FALSE,
  weighted = TRUE, split = c("median", "mean", "forceEqual", "quartiles"))
}
\arguments{
\item{input}{a matrix or data frame of observations (not a network/edgelist).
See included example datasets \code{\link{depression}} and \code{\link{social}}.}

\item{gamma}{the sparsity parameter used in generating networks. Defaults to 0.5
for interval data and 0.25 for binary data}

\item{nodes}{indicates which nodes should be tested. Can be given
as a character string of desired nodes (e.g., c("node1","node2")) or as a numeric
vector of column numbers (e.g., c(1,2)).}

\item{binary.data}{logical. Indicates whether the input data is binary}

\item{weighted}{logical. Indicates whether resultant networks preserve edge weights
or binarize edges. Note: unweighted networks will always result in a network
structure impact of 0 or 1.}

\item{split}{method by which to split network given non-binary data. "median": median split (excluding the median),
"mean": mean split, "forceEqual": creates equally sized groups by partitioning median observations
 to the smaller group, "quartile": uses the top and bottom quartile as groups}
}
\value{
\code{structure.impact()} returns a list of class "\code{structure.impact}" which contains:
 \item{impact}{a named vector containing the network structure impact for each node tested. Network structure impacts are given as absolute values}
 \item{edge}{a list of vectors. Each vector contains a the edge impact of the most strongly impacted edge (e.g., the network structure impact)}
 \item{lo}{a named vector containing the edge estimate for the lower half of the most strongly impacted edge}
 \item{hi}{a named vector containing the edge estimate for the upper half of the most strongly impacted edge}
}
\description{
Generates the network structure impact of each specified node. Network structure
impact can be interpreted as the degree to which the level of a node causes change
in the network structure
}
\details{
For an explanation of impact functions in general, see \code{\link{impact}}.

Network structure impact computes network structure invariance as a
function of node level. Network structure invariance is defined as the absolute value of
the single largest edge invariance between two networks. A large network structure invariance
is generally used to indicate the \emph{instability} of network structure across groups. For instance, a low global
strength invariance coupled with a high network structure invariance would mean that although the
overall connectivity remains stable, the actual structure of those edges is unstable across groups.
}
\examples{
out <- structure.impact(depression[,1:3])
\donttest{
out1 <- structure.impact(depression)
out2 <- structure.impact(depression, gamma=0.65,
    nodes=c("sleep_disturbance", "psychomotor_retardation"))
out3 <- structure.impact(social, binary.data=TRUE)
out4 <- structure.impact(social, nodes=c(1:6, 9), binary.data=TRUE)

summary(out1)
plot(out1)

#Determine which edge drove network structure impact of "sadness"
out1$edge$sadness
}
}
