% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{atomize}
\alias{atomize}
\alias{atomize.networkLite}
\alias{atomize.tbl_df}
\title{Convert Lists to Atomic Vectors Where Possible}
\usage{
atomize(x, ...)

\method{atomize}{networkLite}(x, ..., upcast = FALSE)

\method{atomize}{tbl_df}(x, ..., upcast = FALSE)
}
\arguments{
\item{x}{A \code{networkLite} or \code{tibble} object.}

\item{...}{additional arguments}

\item{upcast}{logical; are we allowed to upcast atomic types when converting
lists to atomic vectors?}
}
\value{
The \code{networkLite} or \code{tibble} with list columns replaced by
atomic vector columns where possible.
}
\description{
Convert Lists to Atomic Vectors Where Possible
}
\details{
The \code{tibble} method examines each column of the \code{tibble}
and replaces the column with the result of calling \code{unlist} on
the column if all of the following are true: the column
\code{is.list} of length greater than zero, each element of which
\code{is.atomic} of length one, and either \code{upcast} is
\code{TRUE} or there is only one unique class amongst all elements
of the column.

The \code{networkLite} method applies the \code{tibble} method to
the edgelist and vertex attribute \code{tibble}s in the
\code{networkLite}.
}
