% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vhat_exch.R
\name{vhat_exch}
\alias{vhat_exch}
\title{Variance computation for linear regression of network response}
\usage{
vhat_exch(e, X, directed = TRUE, nodes = NULL)
}
\arguments{
\item{e}{Vector of residuals, of length \eqn{d}. Column-wise unfolding of adjacency matrix without diagonal entries (self-loops).}

\item{X}{Matrix of covariates from regression, must have \eqn{d} rows.}

\item{directed}{Optional logical indicator of whether input data is for a directed network, default is \code{TRUE}. Undirected data format is lower triangle of adjacencey matrix.}

\item{nodes}{Optional \eqn{d \times 2} matrix indicating the (directed) relation pairs to which each entry in \eqn{e} and each row in \eqn{X} corresponds. If not input, complete network observation is assumed and the size \eqn{d} and \code{directed} must correspond to an appropriate network of size \eqn{n}.}
}
\value{
A an object of class \code{vhat} containing summary information:
\item{vhat}{Estimated variance-covariance matrix of cofficient estimates \eqn{\hat{\beta}}.}
\item{phi}{Vector of variance-covariance parameter estimates.}
\item{corrected}{Logical of whether variance-covariance matrix was corrected from negative definite to positive semi-definite.}
}
\description{
Stand-alone estimation of exchangeable variance matrix based on residuals and design matrix
}
\details{
This function takes \eqn{X} and \eqn{e} values computes the variance-covariante matrix of \eqn{\hat{\beta}} that resulted in the residuals \eqn{e = Y - X \hat{\beta}} assuming that the errors are exchangeable, as based on Marrs (2017).
}
\examples{
set.seed(1)
n <- 10
d <- n*(n-1)
X <- cbind(1, rnorm(d), sample(c(0,1), d, replace=TRUE))
e <- rnorm(d)
vhat_exch(e,X)

}
\references{
Marrs, F. W., McCormick, T. H., & Fosdick, B. K. (2017). Standard errors for regression on relational data with exchangeable errors. arXiv preprint arXiv:1701.05530.
}
\seealso{
\code{\link{lmnet}}, \code{\link{inputs_lmnet}}
}
\keyword{external}
