% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_fasta_file_sequence_lengths.R
\name{check_fasta_file_sequence_lengths}
\alias{check_fasta_file_sequence_lengths}
\title{Check the lengths of the sequences in a FASTA file}
\usage{
check_fasta_file_sequence_lengths(fasta_filename, peptide_length)
}
\arguments{
\item{fasta_filename}{the name of a FASTA file with protein sequences}

\item{peptide_length}{length of a peptide}
}
\value{
Nothing.
}
\description{
Check if the lengths of the sequences in a FASTA file
are at least equal to the desired peptide lengths.
}
\examples{
# FASTA file in which all proteons have a length of at keast 13
fasta_filename <- system.file(
  "extdata", "example.fasta", package = "netmhc2pan"
)
check_fasta_file_sequence_lengths(
  fasta_filename = fasta_filename,
  peptide_length = 13
)
}
\author{
Richèl J.C. Bilderbeek
}
