% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.netmeta.R
\name{print.netmeta}
\alias{print.netmeta}
\title{Print results of network meta-analysis}
\usage{
\method{print}{netmeta}(x, sortvar, comb.fixed = x$comb.fixed,
  comb.random = x$comb.random, prediction = x$prediction,
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  all.treatments = x$all.treatments, details = TRUE, ma = TRUE,
  backtransf = x$backtransf, nchar.trts = x$nchar.trts,
  digits = gs("digits"), digits.se = gs("digits.se"),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"), digits.tau2 = gs("digits.tau2"),
  digits.I2 = gs("digits.I2"), scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"), ...)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{sortvar}{An optional vector used to sort individual studies
(must be of same length as \code{x$TE}).}

\item{comb.fixed}{A logical indicating whether results for the
fixed effects (common effects) model should be printed.}

\item{comb.random}{A logical indicating whether results for the
random effects model should be printed.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{details}{A logical indicating whether further details for
individual studies should be printed.}

\item{ma}{A logical indicating whether summary results of
meta-analysis should be printed.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
deviations and standard errors, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity tests, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistics, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
statistic, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{\dots}{Additional arguments.}
}
\description{
Print method for objects of class \code{netmeta}.
}
\examples{
data(Senn2013)

# Conduct fixed effects network meta-analysis
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                comb.random = FALSE)
print(net1, ref = "plac", digits = 3)

# Conduct random effects network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                comb.fixed = FALSE)
print(net2, ref = "plac", digits = 3)

}
\seealso{
\code{\link{netmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
