\name{print.decomp.design}

\alias{print.decomp.design}

\title{Print method for objects of class decomp.design}

\description{
  Print and summary method for objects of class \code{decomp.design}.
}

\usage{
\method{print}{decomp.design}(x, digits.Q=gs("digits.Q"),
      showall=FALSE,
      digits.pval.Q=gs("digits.pval.Q"),
      digits.tau2=gs("digits.tau2"),
      scientific.pval=gs("scientific.pval"),
      big.mark=gs("big.mark"), ...)
}

\arguments{
  \item{x}{An object of class \code{decomp.design}.}
  \item{digits.Q}{Minimal number of significant digits for Q
    statistics, see \code{print.default}.}
  \item{showall}{A logical indicating whether results should be shown
    for all designs or only designs contributing to chi-squared
    statistics (default).}
  \item{digits.pval.Q}{Minimal number of significant digits for
    p-value of heterogeneity tests, see \code{print.default}.}
  \item{digits.tau2}{Minimal number of significant digits for
    between-study variance, see \code{print.default}.}
  \item{scientific.pval}{A logical specifying whether p-values should
    be printed in scientific notation, e.g., 1.2345e-01 instead of
    0.12345.}
  \item{big.mark}{A character used as thousands separator.} 
  \item{\dots}{Additional arguments (ignored at the moment).}
}

\author{Guido Schwarzer \email{sc@imbi.uni-freiburg.de}, Ulrike Krahn \email{ulrike.krahn@bayer.com}}

\seealso{\code{\link{decomp.design}}}

\examples{
data(Senn2013)

net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data=Senn2013, sm="MD")
print(decomp.design(net1))
}

\keyword{print}
