% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_hot.R
\name{one_hot}
\alias{one_hot}
\title{One-hot encode}
\usage{
one_hot(x, all_levels = TRUE, rename_binary = TRUE, sep = ".")
}
\arguments{
\item{x}{A dataframe, matrix or tibble. Matrices are returned untouched.}

\item{all_levels}{Logical, whether to create dummy variables for all levels
of each factor.}

\item{rename_binary}{Logical, whether to rename binary factors by appending
the 2nd level of the factor to aid interpretation of encoded factor levels
and to allow consistency with naming.}

\item{sep}{Character for separating factor variable names and levels for
encoded columns.}
}
\value{
A numeric matrix with the same number of rows as the input data.
Dummy variable columns replace the input factor or character columns.
Numeric columns are left intact.
}
\description{
Fast one-hot encoding of all factor and character columns in a dataframe to
convert it into a numeric matrix by creating dummy (binary) columns.
}
\details{
Binary factor columns and logical columns are converted to integers (0 or
1). Multi-level unordered factors are converted to multiple columns, one
column for each level (dummy variables). Unused levels are dropped.
Character columns are first converted to factors and then encoded. Ordered
factors are replaced by their internal codes. Numeric or integer columns are
left untouched.

\code{all_levels} is set to \code{TRUE} by default to aid with interpretability (e.g.
with SHAP values), and since filtering might result in some dummy variables
being excluded. However, having dummy variables for all levels of a factor
can cause problems with multicollinearity in regression (the dummy variable
trap), so for regression models such as \code{glmnet}, \code{all_levels} should be set
to \code{FALSE} (equivalent to full rank parameterisation). Note this function is
designed to quickly generate dummy variables for more general machine
learning purposes. To create a proper design matrix object for regression
models, use \code{\link[=model.matrix]{model.matrix()}}.
}
\examples{
data(iris)
x <- iris
x2 <- one_hot(x)
head(x2)  # 3 columns for Species

x2 <- one_hot(x, all_levels = FALSE)
head(x2)  # 2 columns for Species

}
\seealso{
\code{\link[caret:dummyVars]{caret::dummyVars()}}, \code{\link[=model.matrix]{model.matrix()}}
}
