% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_read.R
\name{neon_read}
\alias{neon_read}
\title{read in neon tabular data}
\usage{
neon_read(
  table = NA,
  product = NA,
  site = NA,
  start_date = NA,
  end_date = NA,
  ext = NA,
  dir = neon_dir(),
  files = NULL,
  .id = NA,
  ...
)
}
\arguments{
\item{table}{the name of a downloaded NEON table in the store,
see \link{neon_store}}

\item{product}{Include only files matching this NEON productCode(s)}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{ext}{only match files with this file extension(s)}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{files}{optionally, specify a vector of file paths directly (e.g. as
provided from \link{neon_index}) and specify \code{table} argument as NULL.}

\item{.id}{add an additional id column with metadata from filename.}

\item{...}{additional arguments to \link[vroom:vroom]{vroom::vroom}, can usually be omitted.}
}
\description{
read in neon tabular data
}
\details{
NEON's tabular data files are separated out into separate .csv
files for each site for each month of sampling.  In principle,
each file has identical columns.  \link[vroom:vroom]{vroom::vroom} can read in a
data table that has been sharded into many files like this much
much faster than other parsers can read in each table iteratively,
(and thus can greatly out-perform the 'stacking" methods in \code{neonUtilities}).

Unfortunately, not all datasets are entirely consistent in their use
of columns.  \code{neon_read} works around this by parsing such tables in
groups of matching schema, which is still reasonably fast.

For convenience, \code{neon_read} takes the name of a table in the local store.
}
\examples{

neon_read("brd_countdata-expanded")

## Read in specific files from the neon_index():
files <- neon_index(table = "brd_countdata-expanded")$path
neon_read(files = files)

}
