% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neo4j_query.R
\name{neo4j_query}
\alias{neo4j_query}
\title{Execute a query string in Neo4J using cypher-shell and capture output}
\usage{
neo4j_query(
  con = list(address = NULL, uid = NULL, pwd = NULL),
  qry = NULL,
  shell_path = "cypher-shell",
  database = NULL,
  encryption = c("default", "true", "false")
)
}
\arguments{
\item{con}{List containing three objects: bolt address, uid, pwd as character strings providing connection to the Neo4J server}

\item{qry}{Character string of the query or queries to be sent to Neo4J.  Read queries should be single queries.}

\item{shell_path}{If cypher-shell is not in the PATH system variable, the full local path to cypher-shell executable.}

\item{database}{The name of the database if other than the default database.  (For multi-tenancy installations).}

\item{encryption}{Passes encryption argument to cypher-shell if necessary.  Older versions of cypher-shell may require 'true' or 'false' to be passed.}
}
\value{
A dataframe of results if the read query is successful.  A text string if an error is encountered.
Write queries will return a zero length response if successful.
If multiple read queries were submitted, only the results of the final query will be returned.
}
\description{
Execute a query string in Neo4J using cypher-shell and capture output
}
\examples{
# if neo4j exists, start the local server, give it a moment to fire up, and run a query
if (nzchar(Sys.which("neo4j"))) {
  neo4j_start()
  Sys.sleep(2)
  graph <- list(address = "bolt://localhost:7687", uid = "neo4j", pwd = "password")
  neo4j_query(con = graph, qry = "MATCH (n) RETURN (n)")
}
}
