% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{nstring}
\alias{nstring}
\title{neat representation of string}
\usage{
nstring(string, case = NULL, remove.specials = FALSE)
}
\arguments{
\item{string}{a string / character}

\item{case}{an optional parameter to convert the string variable to specific case.
By default the case of the string is kept as it is. The available case conversions are lower, upper, title and start case.}

\item{remove.specials}{an optional parameter. set to TRUE if special characters including any punctuation
to be removed from the string}
}
\value{
White space cleaned and optionally formatted by case conversion and removal of special characters of the input string.
}
\description{
neat representation of string
}
\examples{
nstring('   All MOdels are wrong.   some ARE useful!!! ', case = 'title', remove.specials = TRUE)
nstring("all Models are Wrong some are Useful", case = 'start', remove.specials = TRUE)
}
\seealso{
Refer to \url{https://en.wikipedia.org/wiki/Letter_case#Stylistic_or_specialised_usage} for more information about the different cases of text/string.
}
