% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_help.R
\name{nbc4vaHelpAdvanced}
\alias{nbc4vaHelpAdvanced}
\title{Advanced usage in nbc4va}
\usage{
nbc4vaHelpAdvanced()
}
\description{
Advanced usage in nbc4va
}
\section{About}{

This documentation page provides details on the advanced usage of the nbc4va package which includes
training a NBC model, evaluating NBC model performance, and plotting the top predicted causes from
the NBC model. The documentation written here is intended for users of R that understand the different
data structures of R such as: \code{\link{data.frame}}, \code{\link{list}}, and \code{\link{vector}}. It
is also required to understand the basic data types: \code{\link{character}}, and \code{\link{numeric}}.
}

\section{Training a NBC Model}{

Run the following code using \code{\link{nbc}} in the R console to train a NBC model.
\preformatted{
--------------------------------------------------------------------------------------------------

    library(nbc4va)

    # Create training and testing dataframes
    data(nbc4vaData)  # example data
    train <- nbc4vaData[1:50, ]
    test <- nbc4vaData[51:100, ]

    # Train a nbc model
    # The "results" variable is a nbc list-like object with elements accessible by $
    # Set "known" to indicate whether or not testing causes are known in "test"
    results <- nbc(train, test, known=TRUE)

    # Obtain the probabilities and predictions
    prob <- results$prob.causes  # vector of probabilities for each test case
    pred <- results$pred.causes  # vector of top predictions for each test case

    # View the "prob" and "pred", the names are the case ids
    head(prob)
    head(pred)

--------------------------------------------------------------------------------------------------
}
\subsection{References for Training a NBC Model}{
  \itemize{
    \item See \code{\link{nbc}} for complete function specifications and usage
    \item See the \code{\link{nbc4vaHelpMethods}} section for the NBC algorithm details
  }
}
}

\section{Evaluating a NBC Model}{

Run the following code using \code{\link{summary.nbc}} in the R console to evaluate a NBC model.
\preformatted{
--------------------------------------------------------------------------------------------------

    library(nbc4va)

    # Create training and testing dataframes
    data(nbc4vaData)
    train <- nbc4vaData[1:50, ]
    test <- nbc4vaData[51:100, ]

    # Train a nbc model
    results <- nbc(train, test, known=TRUE)

    # Automatically calculate metrics with summary
    # The "brief" variable is a nbc_summary list-like object
    # The "brief" variable is "results", but with additional metrics
    brief <- summary(results)

    # Obtain the calculated metrics
    metrics <- brief$metrics.all  # vector of overall metrics
    causeMetrics <- brief$metrics.causes  # dataframe of metrics by cause

    # Access the calculatd metrics
    metrics[["CSMFaccuracy"]]
    metrics[["Sensitivity"]]
    View(causeMetrics)

--------------------------------------------------------------------------------------------------
}
\subsection{References for Evaluating a NBC Model}{
  \itemize{
    \item See \code{\link{summary.nbc}} for complete method specifications and usage
    \item See the \code{\link{nbc4vaHelpMethods}} section for definitions of performance metrics and terms in the output
  }
}
}

\section{Plotting the Top Predicted Causes}{

Run the following code using \code{\link{plot.nbc}} in the R console to produce a bar plot of the top predicted causes.
\preformatted{
--------------------------------------------------------------------------------------------------

    library(nbc4va)

    # Create training and testing data
    data(nbc4vaData)
    train <- nbc4vaData[1:50, ]
    test <- nbc4vaData[51:100, ]

    # Train a nbc model and plot the top 5 causes if possible
    results <- nbc(train, test, known=TRUE)
    plot(results, top=5)
    plot(results, top=5, footnote=FALSE)  # remove footnote

--------------------------------------------------------------------------------------------------
}
\subsection{Example of Plotting the Top Predicted Causes}{
  The image below shows a plot of the top causes of death by predicted CSMFs using \code{\link{plot.nbc}} on a NBC model trained using the \code{\link{nbc4vaData}} included in the package. \cr \cr
  \figure{plotnbcex.png}
}
\subsection{References for Plotting the Top Predicted Causes}{
  \itemize{
    \item See \code{\link{plot.nbc}} for complete method specifications and usage
    \item See the \code{\link{nbc4vaHelpMethods}} section for definition of CSMF and related metrics in the footnote of the plot
  }
}
}
\seealso{
Guide for package: \code{\link{nbc4va}}

Other help functions: \code{\link{nbc4vaHelpBasic}},
  \code{\link{nbc4vaHelpData}},
  \code{\link{nbc4vaHelpDev}},
  \code{\link{nbc4vaHelpFunctions}},
  \code{\link{nbc4vaHelpMethods}}, \code{\link{nbc4vaHelp}}
}

