% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_data.R
\name{internalRoundFixedSum}
\alias{internalRoundFixedSum}
\title{Round values to whole numbers while preserving the sum}
\usage{
internalRoundFixedSum(v, roundSum = round)
}
\arguments{
\item{v}{A vector of values with decimal values and a whole number sum to round.}

\item{roundSum}{If the sum of the values in \emph{v} is not a whole number, choose a rounding method to ensure it is a whole number.}
}
\value{
out A vector of \emph{v} with the values rounded to whole numbers but with the whole number sum preserved.
}
\description{
Rounds a vector of values to whole numbers while preserving the sum (rounded if it is not a whole number) using the largest remainder method \href{https://www.tcd.ie/Political_Science/staff/michael_gallagher/ElectoralStudies1991.pdf}{(Gallagher, 1991)}.
}
\examples{
library(nbc4va)
dec <- c(rep(50/2, 2), rep(50/3, 3))
whole <- nbc4va:::internalRoundFixedSum(dec)

}
\references{
\itemize{
  \item Gallagher M. Proportionality, disproportionality and electoral systems. Electoral Studies. 1991;10(1)33-51. doi:10.1016/0261-3794(91)90004-C.
}
}
\seealso{
Other data functions: \code{\link{internalSubAsRest}}
}
\keyword{internal}

