% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{new_menu}
\alias{new_menu}
\title{Build a new navigation menu}
\usage{
new_menu(
  key = character(),
  value = list(),
  attrs = data_frame(.size = 1),
  ...,
  class = character()
)
}
\arguments{
\item{key}{A unique character vector.
If the key is not a character vector, it is converted to a character vector by \code{\link[=as.character]{as.character()}}.}

\item{value}{A list of values corresponding to the keys.
If the value is not a list, it is converted to a list by \code{\link[=as.list]{as.list()}}.}

\item{attrs}{A data frame for additional attributes of items (an empty data frame by default).
When an item becomes active, the attrs will be added to its attributes.}

\item{...}{Additional arguments passed to \code{\link[vctrs:new_data_frame]{vctrs::new_data_frame()}}.}

\item{class}{A character vector of subclasses passed to \code{\link[vctrs:new_data_frame]{vctrs::new_data_frame()}}.}
}
\value{
A \code{navigatr_menu} object, a subclass of class \code{data.frame}.
}
\description{
To build a new navigation menu, give \code{new_menu()} unique keys and a list of their corresponding values.
The top row shows the menu items (keys on the left, value summaries on the right).
The summaries are \link[pillar:type_sum]{pillar::obj_sum} outputs, so you can change the printing methods.
Each menu item can be accessed by \code{\link[=activate]{activate()}}.
}
\examples{
library(dplyr)

band <- new_menu(key = c("band_members", "band_instruments"),
                 value = list(band_members, band_instruments))
band

# You can also build a nested menu
bands <- new_menu(key = c("key1", "key2"),
                  value = list(band, band))
bands

}
\seealso{
\code{\link[=activate]{activate()}}
}
