% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nauf_stan_regs.R
\name{nauf_stan_glmer}
\alias{nauf_stan_glmer}
\alias{nauf_stan_glmer.nb}
\alias{nauf_stan_lmer}
\title{Fit a Bayesian mixed effects regression with \code{nauf} contrasts.}
\usage{
nauf_stan_glmer(formula, data = NULL, family = gaussian, subset, weights,
  na.action = na.pass, offset, contrasts = NULL, ncs_scale = attr(formula,
  "standardized.scale"), ..., prior = rstanarm::normal(),
  prior_intercept = rstanarm::normal(), prior_aux = rstanarm::cauchy(0, 5),
  prior_covariance = rstanarm::decov(), prior_PD = FALSE,
  algorithm = "sampling", adapt_delta = NULL, QR = FALSE,
  sparse = FALSE)

nauf_stan_lmer(formula, data = NULL, subset, weights, na.action = na.pass,
  offset, contrasts = NULL, ncs_scale = attr(formula, "standardized.scale"),
  ..., prior = rstanarm::normal(), prior_intercept = rstanarm::normal(),
  prior_aux = rstanarm::cauchy(0, 5), prior_covariance = rstanarm::decov(),
  prior_PD = FALSE, algorithm = "sampling", adapt_delta = NULL,
  QR = FALSE)

nauf_stan_glmer.nb(formula, data = NULL, subset, weights,
  na.action = na.pass, offset, contrasts = NULL, link = "log",
  ncs_scale = attr(formula, "standardized.scale"), ...,
  prior = rstanarm::normal(), prior_intercept = rstanarm::normal(),
  prior_aux = rstanarm::cauchy(0, 5), prior_covariance = rstanarm::decov(),
  prior_PD = FALSE, algorithm = "sampling", adapt_delta = NULL,
  QR = FALSE)
}
\arguments{
\item{formula, data, family, subset, weights, na.action, offset, contrasts, ncs_scale}{See
\code{\link{nauf_model.frame}} and \code{\link{nauf_glFormula}}.}

\item{...}{Further arguments to be passed to \code{\link[rstan]{sampling}}.
See \code{\link[rstanarm]{stan_glmer}} for details.}

\item{algorithm}{Changes from the default \code{"sampling"} result in an
error.  Only MCMC is currently supported.}

\item{link, prior, prior_intercept, prior_aux, prior_covariance, prior_PD, adapt_delta, QR, sparse}{See
\code{\link[rstanarm]{stan_glmer}}.}
}
\value{
A \code{\link{nauf.stanreg}} object.
}
\description{
The Bayesian mixed effects regression functions \code{nauf_stan_lmer}, \code{nauf_stan_glmer.nb},
and \code{nauf_stan_glmer} fit linear, negative binomial, and other generalized
linear mixed effects models, respectively, impelementing
\code{\link{nauf_contrasts}}.
}
\details{
\code{nauf_stan_lmer}, \code{nauf_stan_glmer}, and \code{nauf_stan_glmer.nb} are based on
the \code{rstanarm} functions \code{\link[rstanarm]{stan_lmer}}, \code{\link[rstanarm]{stan_glmer}},
and \code{\link[rstanarm]{stan_glmer.nb}}, respectively, but implement
\code{\link{nauf_contrasts}}.  The \code{nauf} functions have all the same
arguments as the functions they are based on, but additionally
\code{ncs_scale}, which is passed to \code{\link{nauf_model.frame}}.  Other
than \code{ncs_scale}, the arguments have the same functions as they do in
the functions they are based on.  The default values for \code{na.action} and
\code{contrasts} cannot be changed (see \code{\link{nauf_model.frame}}).
The default priors for the \code{nauf} Bayesian mixed effects regression
functions are the defaults from \code{rstanarm} version 2.15.3; if you have
a later version of the \code{rstanarm} package, then the default priors for
the \code{nauf} regression fitting functions may be different from the
\code{rstanarm} defaults.
}
\examples{
\dontrun{
sobj <- standardize(vdur ~ place + stress + spont +
  (1 + place + stress + spont | speaker) + (1 | item),
  subset(plosives, dialect == "Cuzco" & voicing == "Voiceless"))

mod <- nauf_stan_lmer(sobj$formula, sobj$data,
  prior = normal(0, 1, autoscale = FALSE),
  prior_intercept = normal(0, 1, autoscale = FALSE),
  prior_aux = normal(0, 1, autoscale = FALSE),
  prior_covariance = decov(2, 1.5, 2, 0.25)
)
}

}
\seealso{
\code{\link{nauf_contrasts}} for a description of the treatment of 
  \code{NA} values, \code{\link[rstanarm]{stan_glmer}} for a description of 
  the priors, and the documentation for \code{Stan} and the \code{rstan} and 
  \code{rstanarm} packages for algorithmic details.
}

