% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rcc.R
\name{rcc}
\alias{rcc}
\alias{read_rcc}
\alias{parse_counts}
\alias{parse_attributes}
\title{Read NanoString RCC files}
\usage{
read_rcc(path = ".")

parse_counts(file)

parse_attributes(file)
}
\arguments{
\item{path}{directory path for multiple RCC files}

\item{file}{RCC file name}
}
\value{
\code{read_rcc()} reads in a directory of RCC files and outputs a list
with two elements:
\itemize{
\item \code{raw}: A tibble of parsed counts for multiple RCC files created by calling
\code{parse_counts()} on each sample. Columns include "Code.Class", "Name",
"Accession", and a column for each sample ID. There is one row per gene.
\item \code{exp}: A tibble of parsed attributes for multiple RCC files created by
calling \code{parse_attributes()} on each sample. Columns include "File.Name"
(sample ID), "geneRLF", "nanostring.date", "cartridgeID", "lane.number",
fov.count", "fov.counted", "binding.density". There is one row per sample.
}

\code{parse_counts()} reads a single RCC file and returns a tibble of
parsed counts.

\code{parse_attributes()} reads a single RCC file and returns a list of
parsed attributes.
}
\description{
Read RCC files and extract count and attribute data. Use \code{read_rcc()} for
multiple files, and use the \verb{parse_*()} functions for single files.
}
\details{
RCC files for a sample are direct outputs from NanoString runs. We can
extract counts for each gene in a sample. Sample attributes include sample
ID, GeneRLF, date, cartridge ID, lane number, Fov count, Fov counted, and
binding density. \code{read_rcc()} merges both count and attribute data across
samples.

If \code{path} points to a zipped RCC file with multiple samples, the zip file is
uncompressed and a directory of RCC sample files is created with the same
name. Only file extensions ".RCC" or ".rcc" are allowed.
}
\examples{
rcc_file <- system.file("extdata", "example.RCC", package = "nanostringr")
parse_counts(rcc_file)
parse_attributes(rcc_file)
read_rcc(dirname(rcc_file))
}
\author{
Derek Chiu
}
