% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-parquet.R
\name{append_parquet}
\alias{append_parquet}
\title{Append a data frame to an existing Parquet file}
\usage{
append_parquet(
  x,
  file,
  compression = c("snappy", "gzip", "zstd", "uncompressed"),
  encoding = NULL,
  row_groups = NULL,
  options = parquet_options()
)
}
\arguments{
\item{x}{Data frame to append.}

\item{file}{Path to the output file.}

\item{compression}{Compression algorithm to use for the newly written
data. See \code{\link[=write_parquet]{write_parquet()}}.}

\item{encoding}{Encoding to use for the newly written data. It does not
have to be the same as the encoding of data in \code{file}. See
\code{\link[=write_parquet]{write_parquet()}} for possible values.}

\item{row_groups}{Row groups of the new, extended Parquet file.
\code{\link[=append_parquet]{append_parquet()}} can only change the last existing row group, and
if \code{row_groups} is specified, it has respect this. I.e. if the
existing file has \code{n} rows, and the last row group starts at \code{k}
(\code{k <= n}), then the first row group in \code{row_groups} that refers to
the new data must start at \code{k} or \code{n+1}.
(It is simpler to specify \code{num_rows_per_row_group} in \code{options}, see
\code{\link[=parquet_options]{parquet_options()}} instead of \code{row_groups}. Only use \code{row_groups} if
you need complete control.)}

\item{options}{Nanoparquet options, for the new data, see
\code{\link[=parquet_options]{parquet_options()}}. The \code{keep_row_groups} option also affects whether
\code{append_parquet()} overwrites existing row groups in \code{file}.}
}
\description{
The schema of the data frame must be compatible with the schema of
the file.
}
\section{Warning}{

This function is \strong{not} atomic! If it is interrupted, it may leave
the file in a corrupt state. To work around this create a copy of the
original file, append the new data to the copy, and then rename the
new, extended file to the original one.
}

\section{About row groups}{

A Parquet file may be partitioned into multiple row groups, and indeed
most large Parquet files are. \code{append_parquet()} is only able to update
the existing file along the row group boundaries. There are two
possibilities:
\itemize{
\item \code{append_parquet()} keeps all existing row groups in \code{file}, and
creates new row groups for the new data. This mode can be forced by
the \code{keep_row_groups} option in \code{options}, see \code{\link[=parquet_options]{parquet_options()}}.
\item Alternatively, \code{write_parquet} will overwrite the \emph{last} row group in
file, with its existing contents plus the (beginning of) the new data.
This mode makes more sense if the last row group is small, because
many small row groups are inefficient.
}

By default \code{append_parquet} chooses between the two modes automatically,
aiming to create row groups with at least \code{num_rows_per_row_group}
(see \code{\link[=parquet_options]{parquet_options()}}) rows. You can customize this behavior with
the \code{keep_row_groups} options and the \code{row_groups} argument.
}

\seealso{
\code{\link[=write_parquet]{write_parquet()}}.
}
