% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(
  url,
  convert = TRUE,
  follow = FALSE,
  method = NULL,
  headers = NULL,
  data = NULL,
  response = NULL,
  timeout = NULL,
  tls = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{convert}{[default TRUE] logical value whether to attempt conversion
of the received raw bytes to a character vector. Set to \code{FALSE} if
downloading non-text data.}

\item{follow}{[default FALSE] logical value whether to automatically follow
redirects (not applicable for async requests). If \code{FALSE}, the redirect
address is returned as response header 'Location'.}

\item{method}{(optional) the HTTP method as a character string. Defaults to
'GET' if not specified, and could also be 'POST', 'PUT' etc.}

\item{headers}{(optional) a named character vector specifying the HTTP
request headers, for example: \cr
\code{c(Authorization = "Bearer APIKEY", "Content-Type" = "text/plain")} \cr
A non-character or non-named vector will be ignored.}

\item{data}{(optional) character string request data to be submitted. If a
vector, only the first element is taken, and non-character objects are
ignored.}

\item{response}{(optional) a character vector specifying the response headers
to return e.g. \code{c("date", "server")}. These are case-insensitive and
will return NULL if not present. A non-character vector will be ignored.}

\item{timeout}{(optional) integer value in milliseconds after which the
transaction times out if not yet complete.}

\item{tls}{(optional) applicable to secure HTTPS sites only, a client TLS
Configuration object created by \code{\link[=tls_config]{tls_config()}}. If missing or NULL,
certificates are not validated.}
}
\value{
Named list of 3 elements:
\itemize{
\item \verb{$status} - integer HTTP repsonse status code (200 - OK).
Use \code{\link[=status_code]{status_code()}} for a translation of the meaning.
\item \verb{$headers} - named list of response headers supplied in \code{response},
or NULL otherwise. If the status code is within the 300 range, i.e. a
redirect, the response header 'Location' is automatically appended to
return the redirect address.
\item \verb{$data} - the response body, as a character string if
\code{convert = TRUE} (may be further parsed as html, json, xml etc. as
required), or a raw byte vector if FALSE (use \code{\link[=writeBin]{writeBin()}} to save as a
file).
}
}
\description{
nano cURL - a minimalist http(s) client.
}
\examples{
ncurl(
  "https://postman-echo.com/get",
  convert = FALSE,
  response = c("date", "content-type"),
  timeout = 1200L
)
ncurl(
  "https://postman-echo.com/put",
  method = "PUT",
  headers = c(Authorization = "Bearer APIKEY"),
  data = "hello world",
  timeout = 1500L
)
ncurl(
  "https://postman-echo.com/post",
  method = "POST",
  headers = c(`Content-Type` = "application/json"),
  data = '{"key":"value"}',
  timeout = 1500L
)

}
\seealso{
\code{\link[=ncurl_aio]{ncurl_aio()}} for asynchronous http requests; \code{\link[=ncurl_session]{ncurl_session()}} for
persistent connections.
}
