% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context}
\alias{context}
\title{Open Context}
\usage{
context(socket, verify = TRUE)
}
\arguments{
\item{socket}{a Socket.}

\item{verify}{[default TRUE] logical value whether to verify there is a
connection at the socket with the result stored internally within the
context (required for features of certain functions). Set to FALSE for
performance if not using features which explicitly require verification.
Supplying a non-logical value will error.}
}
\value{
A new Context (object of class 'nanoContext' and 'nano').
}
\description{
Open a new Context to be used with a Socket. The purpose of a Context is to
    permit applications to share a single socket, with its underlying dialers
    and listeners, while still benefiting from separate state tracking.
}
\details{
Contexts allow the independent and concurrent use of stateful
    operations using the same socket. For example, two different contexts
    created on a rep socket can each receive requests, and send replies to
    them, without any regard to or interference with each other.

    Only the following protocols support creation of contexts: req, rep, sub
    (in a pub/sub pattern), surveyor, respondent.

    To send and receive over a context use \code{\link{send}} and
    \code{\link{recv}} or their async counterparts \code{\link{send_aio}} and
    \code{\link{recv_aio}}.

    For nano objects, use the \code{$context_open()} method, which will
    attach a new context at \code{$context}. See \code{\link{nano}}.
}
\examples{
s <- socket("req", listen = "inproc://nanonext")
ctx <- context(s)
ctx
close(ctx)
close(s)

n <- nano("req", listen = "inproc://nanonext")
n$context_open()
n$context
n$context_open()
n$context
n$context_close()
n$close()

}
