% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{subscribe}
\alias{subscribe}
\alias{unsubscribe}
\title{Subscribe / Unsubscribe Topic}
\usage{
subscribe(con, topic = NULL)

unsubscribe(con, topic = NULL)
}
\arguments{
\item{con}{a Socket or Context using the 'sub' protocol.}

\item{topic}{[default NULL] an atomic type or NULL. The default NULL
subscribes to all topics / unsubscribes from all topics (if all topics
were previously subscribed).}
}
\value{
Invisibly, the passed Socket or Context.
}
\description{
For a socket or context using the sub protocol in a publisher/subscriber
    pattern. Set a topic to subscribe to, or remove a topic from the
    subscription list.
}
\details{
To use pub/sub the publisher must:
    \itemize{
    \item specify \code{mode = 'raw'} when sending.
    \item ensure the sent vector starts with the topic.
    }
    The subscriber should then receive specifying the correct mode.
}
\examples{
pub <- socket("pub", listen = "inproc://nanonext")
sub <- socket("sub", dial = "inproc://nanonext")

subscribe(sub, "examples")

send(pub, c("examples", "this is an example"), mode = "raw")
recv(sub, "character")
send(pub, "examples will also be received", mode = "raw")
recv(sub, "character")
send(pub, c("other", "this other topic will not be received"), mode = "raw")
recv(sub, "character")
unsubscribe(sub, "examples")
send(pub, c("examples", "this example is no longer received"), mode = "raw")
recv(sub, "character")

subscribe(sub, 2)
send(pub, c(2, 10, 10, 20), mode = "raw")
recv(sub, "double")
unsubscribe(sub, 2)
send(pub, c(2, 10, 10, 20), mode = "raw")
recv(sub, "double")

close(pub)
close(sub)

}
