% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number.R
\name{NumberTimeSeries}
\alias{NumberTimeSeries}
\title{Create a number time-series.}
\usage{
NumberTimeSeries(arr, frames.per.set, tau = NA, mst = NULL, filt = NULL,
  n.ch = 1, verbose = FALSE, mcc = parallel::detectCores(), seed = NULL)
}
\arguments{
\item{arr}{A 3-dimensional array (the image stack) where the \eqn{n}th
slice is the \eqn{n}th image in the time series. To perform this on a file
that has not yet been read in, set this argument to the path to that file
(a string).}

\item{frames.per.set}{The number of frames with which to calculate the
successive numbers.}

\item{tau}{If this is specified, bleaching correction is performed with
\code{\link[=CorrectForBleaching]{CorrectForBleaching()}} which uses exponential filtering with
time constant \code{tau} (where the unit of time is the time between
frames). If this is set to \code{'auto'}, then the value of \code{tau} is
calculated automatically via \code{\link[=BestTau]{BestTau()}}.}

\item{mst}{Do you want to apply an intensity threshold prior to calculating
number (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your thresholding
\emph{method} here.}

\item{filt}{Do you want to smooth (\code{filt = 'smooth'}) or median
(\code{filt = 'median'}) filter the number image using
\code{\link[=SmoothFilterB]{SmoothFilterB()}} or \code{\link[=MedianFilterB]{MedianFilterB()}} respectively? If
selected, these are invoked here with a filter radius of 1 and with the
option \code{na_count = TRUE}. If you want to smooth/median filter the
number image in a different way, first calculate the numbers without
filtering (\code{filt = NULL}) using this function and then perform your
desired filtering routine on the result.}

\item{n.ch}{The number of channels in the image (default 1).}

\item{verbose}{If arr3d is specified as a file name, print a message to tell
the user that that file is now being processed (useful for
\code{NumberTxtFolder}, does not work with multiple cores).}

\item{mcc}{The number of cores to use for the parallel processing.}

\item{seed}{If using parallel processing (\code{mcc} > 1), a seed for the random
number generation for \link{BestTau}. Don't use \link{set.seed}, it won't work.}
}
\value{
An array where the \eqn{i}th slice is the \eqn{i}th number image.
}
\description{
Given a stack of images \code{arr3d}, use the first \code{frames.per.set} of them to
create one number image, the next \code{frames.per.set} of them to create
the next number image and so on to get a time-series of number
images. If \code{tau} is specified, bleaching correction is performed via
\code{\link[=CorrectForBleaching]{CorrectForBleaching()}}.
}
\details{
This may discard some images, for example if 175 frames are in the input and
\code{frames.per.set = 50}, then the last 25 are discarded. If bleaching
correction is selected, it is performed on the whole image stack before the
sectioning is done for calculation of numbers.
}
\examples{
library(EBImage)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
bts <- NumberTimeSeries(img, 20, tau = NA, mst = "Huang", mcc = 2)
}
\seealso{
\code{\link[=Number]{Number()}}.
}
