% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib.R
\name{mc_calib_moisture}
\alias{mc_calib_moisture}
\title{Calculates coefficients for TMS moisture conversion to VWC}
\usage{
mc_calib_moisture(
  raw_air,
  raw_water,
  t_air = 24,
  t_water = 24,
  ref_air = 114.534,
  ref_water = 3634.723,
  ref_t = .calib_MOIST_REF_T,
  acor_t = .calib_MOIST_ACOR_T,
  wcor_t = .calib_MOIST_WCOR_T
)
}
\arguments{
\item{raw_air}{Raw TMS moisture records in air}

\item{raw_water}{Raw TMS moisture records in water}

\item{t_air}{temperature of air (default 24)}

\item{t_water}{temperature of water (default 24)}

\item{ref_air}{(default 114.534)}

\item{ref_water}{(default 3634.723)}

\item{ref_t}{(default 24)}

\item{acor_t}{(default 1.91132689118083)}

\item{wcor_t}{(default 0.64108)}
}
\value{
list with slope and intercept parameters
}
\description{
Specialized, service function. You will typically not need to use this one.
Function calculate correction parameters (slope and intercept)
from TMS moisture measurements in pure water and air.
}
\details{
This is highly specialized service function designed to derive correction
parameters \code{slope} and \code{intercept} for soil moisture sensor of TMS loggers
measuring on the air and in the water. Slope and intercept calculated in this
function could be used as sensor-specific alternative in \code{\link[=mc_calc_vwc]{mc_calc_vwc()}}
function instead of defaults. User is not allowed to modify slope and
intercept parameters when calling \code{\link[=mc_calc_vwc]{mc_calc_vwc()}}.
But this must be done in code of the function. It is possible, but advanced,
and typically not necessary, the default values should be working well.
}
\examples{
mc_calib_moisture(120, 3650)
}
