% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_diagnostics.R
\name{mvgam_diagnostics}
\alias{mvgam_diagnostics}
\alias{nuts_params}
\alias{rhat}
\alias{neff_ratio}
\alias{nuts_params.mvgam}
\alias{log_posterior.mvgam}
\alias{rhat.mvgam}
\alias{neff_ratio.mvgam}
\title{Extract diagnostic quantities of \pkg{mvgam} models}
\usage{
\method{nuts_params}{mvgam}(object, pars = NULL, ...)

\method{log_posterior}{mvgam}(object, ...)

\method{rhat}{mvgam}(x, pars = NULL, ...)

\method{neff_ratio}{mvgam}(object, pars = NULL, ...)

\method{neff_ratio}{mvgam}(object, pars = NULL, ...)
}
\arguments{
\item{object, x}{A \code{mvgam} object.}

\item{pars}{An optional character vector of parameter names.
For \code{nuts_params} these will be NUTS sampler parameter
names rather than model parameters. If pars is omitted
all parameters are included.}

\item{...}{Arguments passed to individual methods.}
}
\value{
The exact form of the output depends on the method.
}
\description{
Extract quantities that can be used to diagnose sampling behavior
of the algorithms applied by \pkg{Stan} at the back-end of \pkg{mvgam}.
}
\details{
For more details see
\code{\link[bayesplot:bayesplot-extractors]{bayesplot-extractors}}.
}
\examples{
\donttest{
simdat <- sim_mvgam(n_series = 1, trend_model = 'AR1')
mod <- mvgam(y ~ s(season, bs = 'cc', k = 6),
            trend_model = AR(),
            noncentred = TRUE,
            data = simdat$data_train,
            chains = 2)
np <- nuts_params(mod)
head(np)

# extract the number of divergence transitions
sum(subset(np, Parameter == "divergent__")$Value)

head(neff_ratio(mod))
}
}
