% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{summary}
\alias{summary}
\alias{summary.mverse}
\alias{summary.lm_mverse}
\alias{summary.glm_mverse}
\alias{summary.glm.nb_mverse}
\title{Display the multiverse table with results.}
\usage{
\method{summary}{mverse}(object, ...)

\method{summary}{lm_mverse}(object, conf.int = TRUE, conf.level = 0.95, output = "estimates", ...)

\method{summary}{glm_mverse}(object, conf.int = TRUE, conf.level = 0.95, output = "estimates", ...)

\method{summary}{glm.nb_mverse}(object, conf.int = TRUE, conf.level = 0.95, output = "estimates", ...)
}
\arguments{
\item{object}{a \code{glm.nb_mverse} object.}

\item{...}{Ignored.}

\item{conf.int}{When \code{TRUE} (default), the estimate output
includes the confidence intervals.}

\item{conf.level}{The confidence level of the confidence interval
returned using \code{conf.int = TRUE}. Default value is 0.95.}

\item{output}{The output of interest. The possible values are
"estimates" ("e"), "df", "deviance" ("de"), and "aic" ("bic").
Alternatively, the first letters may be used. Default value
is "estimates".}
}
\value{
a multiverse table as a tibble.
}
\description{
This method returns the multiverse table
displaying all universes defined by the multiverse.
Each row corresponds to a universe and the columns
include universe number, branch option name, and
branch option definition.
}
\details{
When you pass a \code{mverse} objected fitted with model,
the summary table includes results of the fitted models
across the multiverse.
}
\examples{
\donttest{

# Displaying the multiverse table without any fitted values.
hurricane_strength <- mutate_branch(
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014
)
mv <- create_multiverse(hurricane) \%>\%
  add_mutate_branch(hurricane_strength)
summary(mv)
## Displaying after adding a a filter branch.
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  !Name \%in\% c("Katrina"),
  TRUE # include all
)
mv <- add_filter_branch(mv, hurricane_outliers)
summary(mv)
}
\donttest{

# Displaying the multiverse table with \code{lm} models fitted.
hurricane_strength <- mutate_branch(
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014
)
y <- mutate_branch(
  alldeaths, log(alldeaths + 1)
)
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  TRUE # include all
)
model_specifications <- formula_branch(
  y ~ MasFem,
  y ~ MasFem + hurricane_strength
)
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers) \%>\%
  add_mutate_branch(hurricane_strength, y) \%>\%
  add_formula_branch(model_specifications) \%>\%
  lm_mverse()
summary(mv)
}
\donttest{

# Displaying the multiverse table with \code{glm} models fitted.
hurricane_strength <- mutate_branch(
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014
)
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  TRUE # include all
)
model_specifications <- formula_branch(
  alldeaths ~ MasFem,
  alldeaths ~ MasFem + hurricane_strength
)
model_distributions <- family_branch(poisson)
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers) \%>\%
  add_mutate_branch(hurricane_strength) \%>\%
  add_formula_branch(model_specifications) \%>\%
  add_family_branch(model_distributions) \%>\%
  glm_mverse()
summary(mv)
}
\donttest{
# Displaying the multiverse table with \code{glm.nb} models fitted.
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  TRUE # include all
)
model_specifications <- formula_branch(alldeaths ~ MasFem)
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers) \%>\%
  add_formula_branch(model_specifications) \%>\%
  glm.nb_mverse()
summary(mv)
}
}
