% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{leadZeros}
\alias{leadZeros}
\title{Add Leading Zeros to Numbers.}
\usage{
leadZeros(n, m, char = "0", na.value = NA)
}
\arguments{
\item{n}{numeric vector whose numbers are to be transformed}

\item{m}{maximum number that will be used to define how many leading zeros to attach}

\item{char}{string (typically, a single character). This character is used to fill the leading space.
Defaults to 0.}

\item{na.value}{value used to fill mising values. Defaults to NA}
}
\value{
numeric vector of length equal to length(n), where all numbers are converted 
to character and modified by attaching the required number of leading zeros (characters).
}
\description{
Internal function to convert a numeric vector into a character vector, where all elements
have the same number of characters (nchar). This is obtained by pasting a series of leading zeros
(or other character) to each number in the input vector.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\examples{
n = c(5:12, NA, 9:11)
m = 111
mutSignatures:::leadZeros(n=n, m=m)    

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
