% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{filterSNV}
\alias{filterSNV}
\title{Filter Single Nucleotide Variants.}
\usage{
filterSNV(dataSet, seq_colNames)
}
\arguments{
\item{dataSet}{data.frame including variant information}

\item{seq_colNames}{character vector with the names of the columns storing variant data}
}
\value{
a filtered data.frame only including SNVs
}
\description{
Remove entries corresponding to non-SNV, such as insertions and deletions.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("filterSNV")
nrow(x)
y <- mutSignatures::filterSNV(dataSet = x, 
                              seq_colNames = c("REF", "ALT"))
nrow(y)

                    
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
