% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{ivec}
\alias{ivec}
\title{Interval-class vector}
\usage{
ivec(set, edo = 12)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric vector of length \code{floor(edo/2)}
}
\description{
The classic summary of a set's dyadic subset content from pitch-class set theory.
The name \code{ivec} is short for \strong{i}nterval-class \strong{vec}tor.
}
\examples{
ivec(c(0, 1, 4, 6))
ivec(c(0, 1, 3, 7))

#### Z-related sextuple in 24edo:
sextuple <- matrix(
  c(0, 1, 2, 6, 8, 10, 13, 16,
  0, 1, 3, 7, 9, 11, 12, 17,
  0, 1, 6, 8, 10, 13, 14, 16,
  0, 1, 7, 9, 11, 12, 15, 17,
  0, 1, 2, 4, 8, 10, 13, 18,
  0, 2, 3, 4, 8, 10, 15, 18), nrow=6, byrow=TRUE)
apply(sextuple, 1, ivec, edo=24) # The ic-vectors are the 6 identical columns of the output matrix
}
