% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets.R
\name{intervalspectrum}
\alias{intervalspectrum}
\alias{spectrumcount}
\title{Specific sizes corresponding to each generic interval}
\usage{
intervalspectrum(set, edo = 12, rounder = 10)

spectrumcount(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
\code{intervalspectrum} returns a list of length one less than \code{length(set)}. The nth entry of the list
represents the specific sizes of generic interval n. \code{spectrumcount} returns a vector that reports the length
of each entry in that list (i.e. the number of distinct specific intervals for each generic interval).
}
\description{
As defined by Clough and Myerson 1986
(\url{doi:10.1080/00029890.1986.11971924}),
an "interval spectrum" is a list of all the specific (or "chromatic")
intervals that occur as instances of a single generic (or "diatonic")
interval within some reference scale. For instance, in the usual diatonic
scale, the generic interval 1 (a "step" in the scale) comes in two specific
sizes: 1 semitone and 2 semitones. Therefore its interval spectrum
\eqn{\langle 1 \rangle = \{ 1, 2 \}}. These functions calculates the
spectrum for every generic interval within a set and return either a list of specific values in each
spectrum or a summary of how many distinct values there are.
}
\examples{
intervalspectrum(sc(7,35))
qcm_fifth <- meantone_fifth()
qcm_dia <- sort(((0:6)*qcm_fifth)\%\%12)
intervalspectrum(qcm_dia)
just_dia <- 12 * log2(c(1, 9/8, 5/4, 4/3, 3/2, 5/3, 15/8))
intervalspectrum(just_dia)

spectrumcount(just_dia) # The just diatonic scale is trivalent.

# Melodic minor nearly has "Myhill's Property" except for its 3 sizes of fourth and fifth
spectrumcount(sc(7,34)) 
}
