% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regress}
\alias{regress}
\title{Multi-output linear regression}
\usage{
regress(
  X,
  Y,
  preproc = pass(),
  method = c("lm", "enet", "mridge", "pls"),
  intercept = FALSE,
  lambda = 0.001,
  alpha = 0,
  ncomp = ceiling(ncol(X)/2),
  ...
)
}
\arguments{
\item{X}{the set of independent (basis) variables}

\item{Y}{the response matrix}

\item{preproc}{A preprocessing pipeline applied to \code{X} before fitting the model}

\item{method}{the regression method: \code{lm}, \code{enet}, \code{mridge}, or \code{pls}}

\item{intercept}{whether to include an intercept term}

\item{lambda}{ridge shrinkage parameter (for methods \code{mridge} and \code{enet})}

\item{alpha}{the elastic net mixing parameter if method is \code{enet}}

\item{ncomp}{number of PLS components if method is \code{pls}}

\item{...}{extra arguments sent to the underlying fitting function}
}
\value{
a bi-projector of type \code{regress}. The \code{sdev} component of this object
stores the standard deviations of the columns of the design matrix (\code{X} potentially
including an intercept) used in the fit, not the standard deviations of latent
components as might be typical in other \code{bi_projector} contexts (e.g., SVD).
}
\description{
Fit a multivariate regression model for a matrix of basis functions, \code{X}, and a response matrix \code{Y}.
The goal is to find a projection matrix that can be used for mapping and reconstruction.
}
\examples{
# Generate synthetic data
set.seed(123) # for reproducibility
Y <- matrix(rnorm(10 * 100), 10, 100)
X <- matrix(rnorm(10 * 9), 10, 9)

# Fit regression models and reconstruct the fitted response matrix
r_lm <- regress(X, Y, intercept = FALSE, method = "lm")
recon_lm <- reconstruct(r_lm) # Reconstructs fitted Y

r_mridge <- regress(X, Y, intercept = TRUE, method = "mridge", lambda = 0.001)
recon_mridge <- reconstruct(r_mridge)

r_enet <- regress(X, Y, intercept = TRUE, method = "enet", lambda = 0.001, alpha = 0.5)
recon_enet <- reconstruct(r_enet)

r_pls <- regress(X, Y, intercept = TRUE, method = "pls", ncomp = 5)
recon_pls <- reconstruct(r_pls)
}
