%     The multitaper R package
%     Multitaper and spectral analysis package for R
%     Copyright (C) 2009 Karim Rahim 

%     This file is part of the multitaper package for R.

%     The multitaper package is free software: you can redistribute it and
%     /or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation, either version 2 of the License, or
%     any later version.

%     The multitaper package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.

%     You should have received a copy of the GNU General Public License
%     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

%     If you wish to report bugs please contact the author. 
%     karim.rahim@gmail.com
%     112 Jeffery Hall, Queen's University, Kingston Ontario
%     Canada, K7L 3N6

\name{dpss}
\alias{dpss}
\title{Compute the Discrete Prolate Spheroidal Sequences}
\description{
   Compute the Discrete Prolate Spheroidal Sequences for use as
   tapers. This function uses the tridiagonal method and exploits
   symmetry. Note the odd order tapers are normalized so that the slope at the
   centre is positive in accordance with Slepian (1978) and Thomson (1982). This
   differs from Percival and Walden (1993)
}
\usage{
dpss(n,k,nw, returnEigenvalues=TRUE)
}
\arguments{
  \item{n}{n a positive integer, often the length of a time series.}
  \item{k}{k a positive integer, the number of tapers, often 2*nw.}
  \item{nw}{nw a positive double precision number, the time-bandwidth
    parameter.}
  \item{returnEigenvalues}{If true the appropriate eigenvalues are
    calculated and returned using the function dpssToEigenvalues.}
}
\references{
Thomson, D.J (1982)
Spectrum estimation and harmonic analysis. \emph{Proceedings of the IEEE}
Volume \bold{70}, number 9, pp. 1055--1096.

Slepian, D. (1978)
Prolate spheroidal wave functions, Fourier analysis, and
uncertainty. V--The discrete case. \emph{Bell System Technical Journal}
Volume \bold{57}, pp. 1371--1430

Percival, D.B. and Walden, A.T. (1993)
\emph{Spectral analysis for physical applications.}
Cambridge University Press.
}
\examples{
## dpss(10,4,4)
dpss(10,4,4)
}
\keyword{math}
