% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline.R
\name{softmax}
\alias{softmax}
\alias{inv_softmax}
\title{Softmax transform}
\usage{
softmax(x)

inv_softmax(p)
}
\arguments{
\item{x}{\eqn{K-1} vector of reals}

\item{p}{\eqn{K} vector simplex}
}
\value{
\code{softmax()} returns a vector of length \eqn{K} that is a simplex.
\code{inv_softmax()} returns a vector of reals of length \eqn{K-1}.
}
\description{
The softmax transform is a multivariate generalisation of the logit
transform. \code{softmax()} maps a vector of \eqn{K-1} values on the real line to a
\eqn{K}-simplex (i.e. values between 0 and 1, that sum to 1). \code{inv_softmax()}
provides the inverse transform, mapping a \eqn{K}-simplex vector to a vector of
\eqn{K-1} real values.
}
\examples{
x <- c(-1, 3, -0.5, 2)
(p <- softmax(x))
sum(p)
inv_softmax(p)

}
