% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CJS.R
\name{markCJS}
\alias{markCJS}
\title{Fit open population survival models for ``traditional'' capture-mark-recapture data consisting of a single mark type}
\usage{
markCJS(Enc.Mat, covs = data.frame(), mod.p = ~1, mod.phi = ~1,
  parms = c("pbeta", "phibeta"), nchains = 1, iter = 12000,
  adapt = 1000, bin = 50, thin = 1, burnin = 2000, taccept = 0.44,
  tuneadjust = 0.95, proppbeta = 0.1, propzp = 1, propsigmap = 1,
  propphibeta = 0.1, propzphi = 1, propsigmaphi = 1, pbeta0 = 0,
  pSigma0 = 1, phibeta0 = 0, phiSigma0 = 1, l0p = 1, d0p = 0.01,
  l0phi = 1, d0phi = 0.01, initial.values = NULL, link = "probit",
  printlog = FALSE, ...)
}
\arguments{
\item{Enc.Mat}{A matrix of observed encounter histories with rows corresponding to individuals and columns corresponding to sampling occasions. With a single mark type, encounter histories consist of only non-detections (0) and type 1 encounters (1).}

\item{covs}{A data frame of temporal covariates for detection probabilities (ignored unless \code{mms=NULL}). The number of rows in the data frame must equal the number of sampling occasions. Covariate names cannot be "time", "age", or "h"; these names are reserved for temporal, behavioral, and individual effects when specifying \code{mod.p} and \code{mod.phi}.}

\item{mod.p}{Model formula for detection probability (\eqn{p}). For example, \code{mod.p=~1} specifies no effects (i.e., intercept only), \code{mod.p~time} specifies temporal effects, \code{mod.p~age} specifies age effects, \code{mod.p~h} specifies individual heterogeneity, and \code{mod.p~time+age} specifies additive temporal and age effects.}

\item{mod.phi}{Model formula for survival probability (\eqn{\phi}). For example, \code{mod.phi=~1} specifies no effects (i.e., intercept only), \code{mod.phi~time} specifies temporal effects, \code{mod.phi~age} specifies age effects, \code{mod.phi~h} specifies individual heterogeneity, and \code{mod.phi~time+age} specifies additive temporal and age effects.}

\item{parms}{A character vector giving the names of the parameters and latent variables to monitor. Possible parameters are probit-scale detection probability parameters ("\code{pbeta}" for \eqn{p} and "\code{phibeta}" for \eqn{\phi}), probit-scale individual heterogeneity variance terms ("\code{sigma2_zp}" for \eqn{p} and "\code{sigma2_zphi}" for \eqn{\phi}), and probit-scale individual effects ("\code{zp}" and "\code{zphi}"). Latent variable indicators for whether each individual was alive (1) or dead (0) during each sampling occasion ("\code{q}") and the log likelihood ("\code{loglike}") may also be monitored. Setting \code{parms="all"} monitors all possible parameters and latent variables.}

\item{nchains}{The number of parallel MCMC chains for the model.}

\item{iter}{The number of MCMC iterations.}

\item{adapt}{Ignored; no adaptive phase is needed for "probit" link.}

\item{bin}{Ignored; no adaptive phase is needed for "probit" link.}

\item{thin}{Thinning interval for monitored parameters.}

\item{burnin}{Number of burn-in iterations (\code{0 <= burnin < iter}).}

\item{taccept}{Ignored; no adaptive phase is needed for "probit" link.}

\item{tuneadjust}{Ignored; no adaptive phase is needed for "probit" link.}

\item{proppbeta}{Ignored; no adaptive phase is needed for "probit" link.}

\item{propzp}{Ignored; no adaptive phase is needed for "probit" link.}

\item{propsigmap}{Ignored; no adaptive phase is needed for "probit" link.}

\item{propphibeta}{Ignored; no adaptive phase is needed for "probit" link.}

\item{propzphi}{Ignored; no adaptive phase is needed for "probit" link.}

\item{propsigmaphi}{Ignored; no adaptive phase is needed for "probit" link.}

\item{pbeta0}{Scaler or vector (of length k) specifying mean of pbeta ~ multivariateNormal(pbeta0, pSigma0) prior. If \code{pbeta0} is a scaler, then this value is used for all j = 1, ..., k. Default is \code{pbeta0 = 0}.}

\item{pSigma0}{Scaler or k x k matrix specifying covariance matrix of pbeta ~ multivariateNormal(pbeta0, pSigma0) prior. If \code{pSigma0} is a scaler, then this value is used for all pSigma0[j,j] for j = 1, ..., k (with pSigma[j,l] = 0 for all \eqn{j \ne l}). Default is \code{pSigma0 = 1}.}

\item{phibeta0}{Scaler or vector (of length k) specifying mean of phibeta ~ multivariateNormal(phibeta0, phiSigma0) prior. If \code{phibeta0} is a scaler, then this value is used for all j = 1, ..., k. Default is \code{phibeta0 = 0}.}

\item{phiSigma0}{Scaler or k x k matrix specifying covariance matrix of phibeta ~ multivariateNormal(phibeta0, phiSigma0) prior. If \code{phiSigma0} is a scaler, then this value is used for all phiSigma0[j,j] for j = 1, ..., k (with phiSigma[j,l] = 0 for all \eqn{j \ne l}). Default is \code{phiSigma0 = 1}.}

\item{l0p}{Specifies "shape" parameter for [sigma2_zp] ~ invGamma(l0p,d0p) prior. Default is \code{l0p = 1}.}

\item{d0p}{Specifies "scale" parameter for [sigma2_zp] ~ invGamma(l0p,d0p) prior. Default is \code{d0p = 0.01}.}

\item{l0phi}{Specifies "shape" parameter for [sigma2_zphi] ~ invGamma(l0phi,d0phi) prior. Default is \code{l0phi = 1}.}

\item{d0phi}{Specifies "scale" parameter for [sigma2_zphi] ~ invGamma(l0phi,d0phi) prior. Default is \code{d0phi = 0.01}.}

\item{initial.values}{OOptional list of \code{nchain} list(s) specifying initial values for "\code{pbeta}", "\code{phibeta}", "\code{sigma2_zp}", "\code{sigma2_zphi}", "\code{zp}", "\code{zphi}", and "\code{q}". Default is \code{initial.values = NULL}, which causes initial values to be generated automatically.}

\item{link}{Link function for survival and capture probabilities. Only probit link is currently implemented.}

\item{printlog}{Logical indicating whether to print the progress of chains and any errors to a log file in the working directory. Ignored when \code{nchains=1}. Updates are printed to log file as 1\% increments of \code{iter} of each chain are completed. With >1 chains, setting \code{printlog=TRUE} is probably most useful for Windows users because progress and errors are automatically printed to the R console for "Unix-like" machines (i.e., Mac and Linux) when \code{printlog=FALSE}. Default is \code{printlog=FALSE}.}

\item{...}{Additional "\code{parameters}" arguments for specifying \code{mod.p} and \code{mod.phi}. See \code{RMark::\link[RMark]{make.design.data}}.}
}
\value{
A list containing the following:
\item{mcmc}{Markov chain Monte Carlo object of class \code{\link[coda]{mcmc.list}}.}
\item{mod.p}{Model formula for detection probability (as specified by \code{mod.p} above).}
\item{mod.phi}{Model formula for survival probability (as specified by \code{mod.phi} above).}
\item{mod.delta}{Model formula for conditional probability of type 1 or type 2 encounter, given detection (as specified by \code{mod.delta} above).}
\item{DM}{A list of design matrices for detection and survival probability respectively generated by \code{mod.p} and \code{mod.phi}, where DM$p is the design matrix for capture probability (\eqn{p}) and DM$phi is the design matrix for survival probability (\eqn{\phi}).}
\item{initial.values}{A list containing the parameter and latent variable values at iteration \code{iter} for each chain. Values are provided for "\code{pbeta}", "\code{phibeta}", "\code{sigma2_zp}", "\code{sigma2_zphi}", "\code{zp}", "\code{zphi}", and "\code{q}".}
\item{mms}{An object of class \code{multimarksetup}}
}
\description{
This function fits Cormack-Jolly-Seber (CJS) open population models for survival probability (\eqn{\phi}) and capture probability (\eqn{p}) for ``traditional'' capture-mark-recapture data consisting of a single mark type. Using Bayesian analysis methods, Markov chain Monte Carlo (MCMC) is used to draw samples from the joint posterior distribution.
}
\details{
The first time \code{markCJS} (or \code{\link{markClosed}}) is called, it will likely produce a firewall warning alerting users that R has requested the ability to accept incoming network connections. Incoming network connections are required to use parallel processing as implemented in \code{multimarkCJS}. Note that setting \code{parms="all"} is required for any \code{markCJS} model output to be used in \code{\link{multimodelCJS}}.
}
\examples{
\dontshow{
data<-simdataCJS(delta_1=1,delta_2=0)$Enc.Mat
test<-markCJS(data,iter=10,burnin=0)
test.age <- markCJS(data,mod.phi=~age,iter=10,burnin=0,parameters=list(Phi=list(age.bins=c(0,1,4))),right=FALSE)}
\donttest{
# These examples are excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Simulate open population data using defaults
data <- simdataCJS(delta_1=1,delta_2=0)$Enc.Mat

#Fit default open population model
sim.dot <- markCJS(data)

#Posterior summary for monitored parameters
summary(sim.dot$mcmc)
plot(sim.dot$mcmc)

#Fit ``age'' model with 2 age classes (e.g., juvenile and adult) for survival
#using 'parameters' and 'right' arguments from RMark::make.design.data
sim.age <- markCJS(data,mod.phi=~age,
           parameters=list(Phi=list(age.bins=c(0,1,4))),right=FALSE)
summary(getprobsCJS(sim.age))}
}
\author{
Brett T. McClintock
}
\seealso{
\code{\link{processdata}}, \code{\link{multimodelCJS}}
}

